var samplePageObj = {
  // 샘플 타이틀
  title: 'Enum형 컬럼',
  subtitle: 'Suggest(col) 속성, Enum(col) 속성을 통해 해당 컬럼에서 사용자의 기준에 따라 다양한 방법으로 정보를 표현할 수 있습니다.',
  // 샘플 설명
  desc:
  `
    임원 컬럼에 체크박스 클릭시 팀명, 직급 컬럼의 내용이 변경됩니다. <br/>
    연령대, 거주지 컬럼은 입력시 자동으로 글자가 필터링되어 보여집니다. <br/>
    주소 컬럼은 입력시 서버에 요청한 데이터를 필터링하여 보여집니다.
  `,
  // 객체 초기화 구문
  init: {
    Def: {
      Header: {},
      Col: {
        Spanned: 1,
        SuggestType: 'Search,Empty,Start,IgnoreSpace'
      },
      Spacer: {
        CanFocus: 0,
        Width: 5
      },
      Row: {
        CanFormula: true,
        CalcOrder: 'sTeamSuggest,sPosEnum,sPosEnumKeys,sTeamColor,sPosColor'
      }
    },
    Cfg: {
      SearchMode: 0,
      MaxPages: 3,
      SuppressMessage: 3
    },
    LeftCols: [
      {
        Type: 'Int',
        Width: 50,
        Align: 'Center',
        Name: 'SEQ'
      }
    ],
    Cols: [
      {
        Header: {
          Value: '임원',
          Align: 'Center',
          Icon: 'Check',
          HeaderCheck: 1
        },
        Type: 'Bool',
        Name: 'Chk'
      },
      {
        Header: '부서명',
        Type: 'Text',
        Name: 'sDept',
        Width: '130',
        Align: 'Center',
        CanEdit: 1,
        RawSort: 1,
        Suggest: '|CEO|SI사업부|인사부|솔루션사업부|영업팀|기술연구소|경영지원팀'
      },
      {
        Header: '팀명',
        Type: 'Text',
        Name: 'sTeam',
        Width: '110',
        Align: 'Center',
        CanEdit: 1,
        RawSort: 1,
        ColorFormula: changeColorFormula,
        SuggestFormula: suggestFormula
      },
      {
        Header: '직급',
        Type: 'Enum',
        Name: 'sPos',
        Width: '95',
        Align: 'Center',
        ColorFormula: changeColorFormula,
        CanEdit: 1,
        RawSort: 1,
        Enum: '|대표이사|이사|상무|소장|차장|부장|과장|대리|사원',
        EnumKeys: '|01A|02A|03A|04A|04B|05B|06B|07B|08B|09B',
        EnumFormula: enumFormula,
        EnumKeysFormula: enumKeysFormula
      },
      {
        Header: '성명',
        Type: 'Text',
        Name: 'sName',
        MinWidth: '100',
        Align: 'Center',
        CanEdit: 1,
        RawSort: 1
      },
      {
        Header: '성별',
        Type: 'Enum',
        Name: 'sSex',
        Width: '70',
        Align: 'Center',
        CanEdit: 1,
        RawSort: 1,
        Enum: '|남자|여자',
        EnumKeys: '|男|女',
      },
      {
        Header: '연령대',
        Type: 'Text',
        Name: 'sAge2',
        Width: '70',
        Align: 'Center',
        CanEdit: 1,
        RawSort: 1,
        Suggest: '|10대|20대|30대|40대|50대|60대 이상'
      },
      {
        Header: '거주지',
        Type: 'Text',
        Name: 'sAddr1',
        Width: '80',
        Align: 'Center',
        CanEdit: 1,
        RawSort: 1,
        Suggest: '|서울|경기|강원'
      },
      {
        Header: '나이',
        Type: 'Int',
        Name: 'sAge',
        Width: '65',
        Align: 'Right',
        CanEdit: 1,
        RawSort: 1,
        Format: '#0세',
        Visible: 0
      },
      {
        Header: '근속기간',
        Type: 'Int',
        Name: 'sYearOfService',
        Width: '85',
        Align: 'Right',
        CanEdit: 1,
        RawSort: 1,
        Format: '#0년',
        Visible: 0
      },
      {
        Header: '급여',
        Type: 'Int',
        Name: 'sSalary',
        Width: '100',
        Align: 'Right',
        CanEdit: 1,
        RawSort: 1,
        Format: '#,##0원',
        Visible: 0
      },
      {
        Header: '상여',
        Type: 'Int',
        Name: 'sBonus',
        Width: '100',
        Align: 'Right',
        CanEdit: 1,
        RawSort: 1,
        Format: '#,##0원',
        Visible: 0
      },
      {
        Header: '도로명 주소',
        Type: 'Text',
        Name: 'sAddr',
        MinWidth: 250,
        CanEdit: 1,
        RelWidth: 1,
        SuggestDelay: 500,
        Enum: '',
        EnumKeys: '',
        EditEnum: '',
        EmptyValue: '<span style=\'color:#AAA\'>도로명 주소를 입력해주세요 (ex : 서울시 OO구 OO로)</span>'
      }
    ]
  },
  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div>'
        + '<span>주소 컬럼에 표시되는 아이템 개수 설정&nbsp;&nbsp;</span><input type=\'number\' id=\'showLineInput\' max=\'15\' min=\'1\' class=\'mgr10\' value=\'10\' style=\'width:60px;\'><button type=\'button\' class=\'mgr10\' onclick=\'sampleBtn(this)\'>변경</button>'
        + '</div>',
  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',
  // 시트 하단 영역 html
  footer: '',
  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },
  // 버튼 클릭시 기능 로직
  action: function () {
    var btnObj = arguments[0];

    if (btnObj.innerText === '변경') {
      var searchStr = '서울특별시 마포구';
      var showLine = document.getElementById('showLineInput').value;
      var btnMsg = '';

      if (isNaN(showLine)) { btnMsg = '<span>숫자만 입력 가능합니다</span>'; }
      if (showLine > 15 || showLine < 1) { btnMsg = '<span>아이템 개수는 최소 1개, 최대 15개 입니다.</span>'; }
      if (btnMsg !== '') {
        sheet.showMessageTime({
          message: btnMsg,
          time: 0,
          importance: 4
        });

        return;
      }
      $('#showLineInput').val(showLine);
      sheet.showMessageTime({
        message: '<span>아이템 개수 변경 완료.</span>',
        time: 0,
        importance: 4
      });
      var url = location.href.indexOf('localhost') > -1 ? '../jsp/samples/customer/enum_calldata.jsp' : 'https://api.ibleaders.com/ibsheet/v8/samples/customer/enum_calldata.jsp';
      var params = {
        param: {
          searchStr: searchStr,
          showLine: showLine
        },
        url: url,
        colName: 'sAddr',
        method: 'POST',
        reqHeaders: {}
      };

      sheet.makeEditEnumList(params);
    }
  },
  // event구문
  event: {
    onAfterChange: function (evtParam) {
      /** 체크박스 선택 후 값 변경시 기본 선택값 부여 */
      if (evtParam.col === 'Chk') {
        if (evtParam.val) {
          evtParam.sheet.setValue(evtParam.row, 'sTeam', '임원');
          evtParam.sheet.setValue(evtParam.row, 'sPos', '대표이사');
        } else {
          evtParam.sheet.setValue(evtParam.row, 'sTeam', '인사2팀');
          evtParam.sheet.setValue(evtParam.row, 'sPos', '차장');
        }
      } else if (evtParam.col === 'sAddr' && evtParam.val === ' 검색된 결과가 없습니다') {
        evtParam.sheet.setValue(evtParam.row, evtParam.col, '');
      }
    },
    onRenderFirstFinish: function (evtParam) {
      evtParam.sheet.showMessage({
        message: '<span>초기 데이터 로드 중입니다.</span>',
        type: 1,
        importance: 4
      });
      var url = location.href.indexOf('localhost') > -1 ? '../jsp/samples/customer/enum_calldata.jsp' : 'https://api.ibleaders.com/ibsheet/v8/samples/customer/enum_calldata.jsp';
      var showLine = document.getElementById('showLineInput').value;
      var params = {
        param: {
          searchStr: '서울특별시 마포구',
          showLine: showLine
        },
        url: url,
        colName: 'sAddr',
        method: 'POST',
        reqHeaders: {}
      };

      // 기본값 셋팅
      evtParam.sheet.makeEditEnumList(params);
      setTimeout(function () { evtParam.sheet.hideMessage(); }, 100);
    },
    onSuggest: function (evtParam) {
      /** ajax 통신을 통한 자동완성 컬럼 */
      var url = location.href.indexOf('localhost') > -1 ? '../jsp/samples/customer/enum_calldata.jsp' : 'https://api.ibleaders.com/ibsheet/v8/samples/customer/enum_calldata.jsp';
      var showLine = document.getElementById('showLineInput').value;
      var searchStr = evtParam.val;
      var lastStr = searchStr.charAt(searchStr.length - 1);

      switch (lastStr) {
        case '시': case '군': case '구': searchStr = searchStr.slice(0, -1); break; default:
      }

      var params = {
        param: {
          searchStr: searchStr,
          showLine: showLine
        },
        url: url,
        colName: 'sAddr',
        method: 'POST',
        reqHeaders: {}
      };

      if (evtParam.col === 'sAddr') {
        return evtParam.sheet.makeEditEnumList(params);
      }

      return evtParam.suggest;
    }
  },
  // data
  data: [
    {
      Chk: '1',
      sDept: 'CEO',
      sTeam: '임원',
      sPos: '대표이사',
      sName: '황정열',
      sSex: '男',
      sAge2: '50대',
      sAddr1: '서울',
      sAge: 50,
      sYearOfService: 15,
      sSalary: 10122200,
      sBonus: 1012220
    },
    {
      Chk: '1',
      sDept: 'SI사업부',
      sTeam: '임원',
      sPos: '상무',
      sName: '강대호',
      sSex: '男',
      sAge2: '40대',
      sAddr1: '경기',
      sAge: 47,
      sYearOfService: 15,
      sSalary: 6756170,
      sBonus: 675617
    },
    {
      Chk: '0',
      sDept: 'SI사업부',
      sTeam: '개발2팀',
      sPos: '부장',
      sName: '김미경',
      sSex: '女',
      sAge2: '30대',
      sAddr1: '강원',
      sAge: 39,
      sYearOfService: 12,
      sSalary: 4180950,
      sBonus: 418095
    },
    {
      Chk: '0',
      sDept: 'SI사업부',
      sTeam: '개발2팀',
      sPos: '과장',
      sName: '김선희',
      sSex: '女',
      sAge2: '30대',
      sAddr1: '경기',
      sAge: 34,
      sYearOfService: 7,
      sSalary: 3217000,
      sBonus: 321700
    },
    {
      Chk: '0',
      sDept: 'SI사업부',
      sTeam: '개발2팀',
      sPos: '과장',
      sName: '최세희',
      sSex: '女',
      sAge2: '30대',
      sAddr1: '경기',
      sAge: 32,
      sYearOfService: 3,
      sSalary: 2750800,
      sBonus: 275080
    },
    {
      Chk: '0',
      sDept: 'SI사업부',
      sTeam: '개발2팀',
      sPos: '대리',
      sName: '이명희',
      sSex: '女',
      sAge2: '20대',
      sAddr1: '서울',
      sAge: 29,
      sYearOfService: 3,
      sSalary: 2571900,
      sBonus: 257190
    },
    {
      Chk: '0',
      sDept: 'SI사업부',
      sTeam: '개발2팀',
      sPos: '사원',
      sName: '노효일',
      sSex: '男',
      sAge2: '20대',
      sAddr1: '서울',
      sAge: 23,
      sYearOfService: 1,
      sSalary: 1520150,
      sBonus: 152020
    },
    {
      Chk: '0',
      sDept: 'SI사업부',
      sTeam: '개발2팀',
      sPos: '사원',
      sName: '원영국',
      sSex: '男',
      sAge2: '20대',
      sAddr1: '경기',
      sAge: 28,
      sYearOfService: 2,
      sSalary: 2557000,
      sBonus: 255700
    },
    {
      Chk: '0',
      sDept: 'SI사업부',
      sTeam: '개발2팀',
      sPos: '사원',
      sName: '이지선',
      sSex: '女',
      sAge2: '20대',
      sAddr1: '서울',
      sAge: 24,
      sYearOfService: 2,
      sSalary: 2007500,
      sBonus: 200750
    },
    {
      Chk: '0',
      sDept: '인사부',
      sTeam: '인사2팀',
      sPos: '부장',
      sName: '김상도',
      sSex: '男',
      sAge2: '40대',
      sAddr1: '경기',
      sAge: 40,
      sYearOfService: 9,
      sSalary: 4290850,
      sBonus: 429085
    },
    {
      Chk: '0',
      sDept: '인사부',
      sTeam: '인사2팀',
      sPos: '대리',
      sName: '한보라',
      sSex: '女',
      sAge2: '20대',
      sAddr1: '서울',
      sAge: 28,
      sYearOfService: 5,
      sSalary: 1959500,
      sBonus: 195950
    },
    {
      Chk: '0',
      sDept: '인사부',
      sTeam: '인사2팀',
      sPos: '사원',
      sName: '장태우',
      sSex: '男',
      sAge2: '20대',
      sAddr1: '서울',
      sAge: 28,
      sYearOfService: 1,
      sSalary: 1959500,
      sBonus: 195950
    },
    {
      Chk: '0',
      sDept: '인사부',
      sTeam: '인사2팀',
      sPos: '차장',
      sName: '정필석',
      sSex: '男',
      sAge2: '40대',
      sAddr1: '경기',
      sAge: 40,
      sYearOfService: 4,
      sSalary: 3851150,
      sBonus: 385120
    },
    {
      Chk: '0',
      sDept: '솔루션사업부',
      sTeam: '인사2팀',
      sPos: '차장',
      sName: '조성목',
      sSex: '男',
      sAge2: '40대',
      sAddr1: '경기',
      sAge: 41,
      sYearOfService: 15,
      sSalary: 6313700,
      sBonus: 631370
    },
    {
      Chk: '0',
      sDept: '솔루션사업부',
      sTeam: '개발2팀',
      sPos: '부장',
      sName: '유봉근',
      sSex: '男',
      sAge2: '40대',
      sAddr1: '서울',
      sAge: 42,
      sYearOfService: 5,
      sSalary: 5187610,
      sBonus: 518760
    },
    {
      Chk: '0',
      sDept: '솔루션사업부',
      sTeam: '개발2팀',
      sPos: '차장',
      sName: '오필환',
      sSex: '男',
      sAge2: '30대',
      sAddr1: '서울',
      sAge: 37,
      sYearOfService: 4,
      sSalary: 3412510,
      sBonus: 341250
    },
    {
      Chk: '0',
      sDept: '솔루션사업부',
      sTeam: '개발2팀',
      sPos: '차장',
      sName: '송복석',
      sSex: '男',
      sAge2: '30대',
      sAddr1: '경기',
      sAge: 39,
      sYearOfService: 6,
      sSalary: 3871680,
      sBonus: 387170
    },
    {
      Chk: '0',
      sDept: '솔루션사업부',
      sTeam: '개발2팀',
      sPos: '과장',
      sName: '김남연',
      sSex: '男',
      sAge2: '30대',
      sAddr1: '서울',
      sAge: 36,
      sYearOfService: 4,
      sSalary: 3500700,
      sBonus: 350070
    },
    {
      Chk: '0',
      sDept: '솔루션사업부',
      sTeam: '개발2팀',
      sPos: '대리',
      sName: '한혜선',
      sSex: '女',
      sAge2: '20대',
      sAddr1: '서울',
      sAge: 29,
      sYearOfService: 2,
      sSalary: 2746000,
      sBonus: 274600
    },
    {
      Chk: '0',
      sDept: '솔루션사업부',
      sTeam: '개발2팀',
      sPos: '사원',
      sName: '조미미',
      sSex: '女',
      sAge2: '20대',
      sAddr1: '서울',
      sAge: 25,
      sYearOfService: 2,
      sSalary: 2297040,
      sBonus: 229700
    },
    {
      Chk: '0',
      sDept: '솔루션사업부',
      sTeam: '개발2팀',
      sPos: '사원',
      sName: '고은혜',
      sSex: '女',
      sAge2: '20대',
      sAddr1: '서울',
      sAge: 26,
      sYearOfService: 1,
      sSalary: 2390740,
      sBonus: 239070
    },
    {
      Chk: '0',
      sDept: '솔루션사업부',
      sTeam: '개발2팀',
      sPos: '사원',
      sName: '성열',
      sSex: '男',
      sAge2: '20대',
      sAddr1: '서울',
      sAge: 27,
      sYearOfService: 1,
      sSalary: 2409000,
      sBonus: 240900
    },
    {
      Chk: '0',
      sDept: '솔루션사업부',
      sTeam: '개발2팀',
      sPos: '사원',
      sName: '김영중',
      sSex: '女',
      sAge2: '20대',
      sAddr1: '인천',
      sAge: 28,
      sYearOfService: 3,
      sSalary: 2871100,
      sBonus: 287110
    },
    {
      Chk: '0',
      sDept: '솔루션사업부',
      sTeam: '개발2팀',
      sPos: '부장',
      sName: '김명호',
      sSex: '男',
      sAge2: '30대',
      sAddr1: '서울',
      sAge: 38,
      sYearOfService: 8,
      sSalary: 3709800,
      sBonus: 370980
    },
    {
      Chk: '0',
      sDept: '솔루션사업부',
      sTeam: '개발2팀',
      sPos: '사원',
      sName: '하태선',
      sSex: '男',
      sAge2: '20대',
      sAddr1: '서울',
      sAge: 28,
      sYearOfService: 1,
      sSalary: 2415010,
      sBonus: 241500
    },
    {
      Chk: '0',
      sDept: '솔루션사업부',
      sTeam: '영업팀',
      sPos: '사원',
      sName: '김정민',
      sSex: '男',
      sAge2: '30대',
      sAddr1: '경기',
      sAge: 32,
      sYearOfService: 3,
      sSalary: 2989010,
      sBonus: 298900
    },
    {
      Chk: '0',
      sDept: '솔루션사업부',
      sTeam: '기술지원팀',
      sPos: '차장',
      sName: '장성훈',
      sSex: '男',
      sAge2: '30대',
      sAddr1: '서울',
      sAge: 37,
      sYearOfService: 5,
      sSalary: 3880150,
      sBonus: 388020
    },
    {
      Chk: '0',
      sDept: '솔루션사업부',
      sTeam: '기술지원팀',
      sPos: '차장',
      sName: '강윤식',
      sSex: '男',
      sAge2: '30대',
      sAddr1: '서울',
      sAge: 35,
      sYearOfService: 7,
      sSalary: 3855600,
      sBonus: 385560
    },
    {
      Chk: '0',
      sDept: '솔루션사업부',
      sTeam: '기술지원팀',
      sPos: '대리',
      sName: '김수연',
      sSex: '女',
      sAge2: '30대',
      sAddr1: '경기',
      sAge: 30,
      sYearOfService: 1,
      sSalary: 2698800,
      sBonus: 269880
    },
    {
      Chk: '0',
      sDept: '솔루션사업부',
      sTeam: '기술지원팀',
      sPos: '대리',
      sName: '정은지',
      sSex: '女',
      sAge2: '30대',
      sAddr1: '서울',
      sAge: 30,
      sYearOfService: 1,
      sSalary: 2698800,
      sBonus: 269880
    },
    {
      Chk: '0',
      sDept: '영업팀',
      sTeam: '영업팀',
      sPos: '사원',
      sName: '정창호',
      sSex: '男',
      sAge2: '20대',
      sAddr1: '서울',
      sAge: 27,
      sYearOfService: 1,
      sSalary: 1897500,
      sBonus: 189750
    },
    {
      Chk: '0',
      sDept: '영업팀',
      sTeam: '영업팀',
      sPos: '대리',
      sName: '김대현',
      sSex: '男',
      sAge2: '30대',
      sAddr1: '서울',
      sAge: 33,
      sYearOfService: 5,
      sSalary: 2709800,
      sBonus: 270980
    },
    {
      Chk: '0',
      sDept: '기술연구소',
      sTeam: '연구2팀',
      sPos: '차장',
      sName: '안남주',
      sSex: '女',
      sAge2: '30대',
      sAddr1: '서울',
      sAge: 38,
      sYearOfService: 10,
      sSalary: 4891350,
      sBonus: 489140
    },
    {
      Chk: '0',
      sDept: '기술연구소',
      sTeam: '연구2팀',
      sPos: '차장',
      sName: '이민수',
      sSex: '男',
      sAge2: '30대',
      sAddr1: '경기',
      sAge: 38,
      sYearOfService: 8,
      sSalary: 3845010,
      sBonus: 384500
    },
    {
      Chk: '0',
      sDept: '기술연구소',
      sTeam: '연구2팀',
      sPos: '차장',
      sName: '최갑석',
      sSex: '男',
      sAge2: '30대',
      sAddr1: '경기',
      sAge: 38,
      sYearOfService: 5,
      sSalary: 3500700,
      sBonus: 350070
    },
    {
      Chk: '0',
      sDept: '기술연구소',
      sTeam: '연구2팀',
      sPos: '차장',
      sName: '김태헌',
      sSex: '男',
      sAge2: '30대',
      sAddr1: '경기',
      sAge: 37,
      sYearOfService: 6,
      sSalary: 3489000,
      sBonus: 348900
    },
    {
      Chk: '0',
      sDept: '기술연구소',
      sTeam: '연구2팀',
      sPos: '과장',
      sName: '박정석',
      sSex: '男',
      sAge2: '30대',
      sAddr1: '서울',
      sAge: 32,
      sYearOfService: 3,
      sSalary: 2885000,
      sBonus: 288500
    },
    {
      Chk: '0',
      sDept: '기술연구소',
      sTeam: '연구2팀',
      sPos: '과장',
      sName: '권기윤',
      sSex: '男',
      sAge2: '30대',
      sAddr1: '경기',
      sAge: 37,
      sYearOfService: 7,
      sSalary: 3450100,
      sBonus: 345010
    },
    {
      Chk: '0',
      sDept: '경영지원팀',
      sTeam: '경영2팀',
      sPos: '차장',
      sName: '김승운',
      sSex: '男',
      sAge2: '30대',
      sAddr1: '경기',
      sAge: 39,
      sYearOfService: 2,
      sSalary: 3505700,
      sBonus: 350570
    },
    {
      Chk: '0',
      sDept: '경영지원팀',
      sTeam: '경영2팀',
      sPos: '사원',
      sName: '이해영',
      sSex: '女',
      sAge2: '20대',
      sAddr1: '경기',
      sAge: 23,
      sYearOfService: 1,
      sSalary: 1800800,
      sBonus: 180080
    }
  ]
};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};

function changeColorFormula(f) {
  return f.Sheet.getValue(f.Row, 'Chk') ? '#ABF0F7' : '#ABF7B8';
}

function suggestFormula(f) {
  return f.Sheet.getValue(f.Row, 'Chk') ? '|임원|연구1팀|경영1팀|개발1팀|기술1팀' : '|인사2팀|개발2팀|영업팀|기술2팀|기술지원팀';
}

function enumFormula(f) {
  return f.Sheet.getValue(f.Row, 'Chk') ? '|대표이사|이사|상무|소장' : '|차장|부장|과장|대리|사원';
}

function enumKeysFormula(f) {
  return f.Sheet.getValue(f.Row, 'Chk') ? '|01A|02A|03A|04A' : '|04B|05B|06B|07B|08B|09B';
}
